
    #   Plot time-binned data

    require 'getopts.pl';
    require 'csv.pl';

    $Ifile = 'STDIN';
    $Outfile = 'lw.gif';
    $Tlabel = 'Hour of day';

    #   Process command line options and set processing modes

    &Getopts('i:o:t:u');

    if ($opt_u) {
        print STDERR <<"EOD";
Usage: perl longwave.pl [ options ]
       Options:
                 -ifile   Read input from named file
                 -ofile   Write GIF output to named file
                 -tlabel  Use label for time axis
                 -u       Print this message
EOD
        exit(0);
    }

    if (defined $opt_i) {
        $Ifile = $opt_i;
        open($Ifile, "<$Ifile") || die("Cannot open input file $Ifile");
    }

    if (defined $opt_o) {
        $Outfile = $opt_o;
    }

    if (defined $opt_t) {
        $Tlabel = $opt_t;
    }

    #   Filter for postprocessing GNUPLOT output into a .GIF file,
    #   translating colours to improve readability

    $gnuplot_filter = "pnmdepth 255 | " .     # Reset MAXVAL to 255 for ppmchange
                      "ppmchange " .          # Translate colours:
                           "rgb:ff/ff/ff rgb:40/40/40 " .   # Background -> Dark Grey
#                          "rgb:00/00/00 rgb:00/00/00 " .   # Text -> White
                           "rgb:ff/55/55 rgb:ff/00/00 " .   # First plot -> Red
                           "rgb:55/ff/55 rgb:00/00/ff | " . # Second plot -> Blue
                       "ppmtogif -interlace -transparent rgb:40/40/40 ";# Emit interlaced GIF 

    #   Read longwave data from standard input and generate GNUPLOT
    #   data file.

    open(LWD, ">lw.dat");
    while ($l = <$Ifile>) {
        chop($l);

        @fields = &csv($l);
        print(LWD "$fields[0] $fields[3]\n");
    }
    close(LWD);

    #   Create GNUPLOT command file

    open(GP, ">lw.gp");
    $tickx = "set xtics(";
    for ($i = 0; $i <= 24; $i++) {
        $hrs = $i * 60 * 60;
        $tickx .= "\"$i\" $hrs, ";
    }
    $tickx =~ s/, $/)/;

    print GP <<"EOH";
set term pbm small color
set title \"Aggregate mean value by $Tlabel\"
set nokey
set xlabel \"$Tlabel\"
set ylabel \"Mean Value\"
#set yrange [99:101]
$tickx
plot \"lw.dat\" using 1:2 with lines
EOH
    close(GP);

    #   Create the plot and postprocess into GIF

    system("gnuplot lw.gp | $gnuplot_filter >$Outfile");
