

    #   Search for periodicities in aggregate egg data

#   $Datadir = '/ftp/entrenous/egg/webtree/data/eggsummary'; # Data archive directory
    $Datadir = '/home/httpd/html/data/eggsummary';
    $OutputFile = 'timebin.csv';      # Output file name
    $Binsize = 60 * 15;               # Bin size in seconds

    #   $BinBy controls the nature of the binning:
    #
    #       0   Universal time
    #       1   Local mean solar time
    #       2   Greenwich mean sidereal time
    #       3   Local mean sidereal time

    $BinBy = 0;

    #   The following table gives, indexed by egg number,
    #   the time zone offset of each egg's location from
    #   UTC.  This should really be read from a CSV file
    #   or computed based on the egg's location.

    $Minutes = 60;
    $Hours = 60 * $Minutes;

    $offset[1] = -4 * $Hours;
    $offset[28] = -4 * $Hours;
    $offset[33] = -5 * $Hours;
    $offset[37] = 2 * $Hours;
    $offset[1000] = 2 * $Hours;
    $offset[1003] = 2 * $Hours;
    $offset[1005] = -7 * $Hours;

    $SecPerDay = 24 * 60 * 60;

    require 'getopts.pl';
    require 'csv.pl';

    #   Process command line options and set processing modes

    &Getopts('b:d:lo:su');

    if ($opt_u) {
        print STDERR <<"EOD";
Usage: perl longwave.pl [ options ]
       Options:
                 -bn    Bin size n seconds
                 -ddir  Use dir as archived egg data directory
                 -l     Bin by local time at egg site
                 -ofile Write CSV output to named file
                 -s     Bin by sidereal, not solar time
                 -u     Print this message
EOD
        exit(0);
    }

    if (defined $opt_b) {
        $Binsize = $opt_b;
        if ($Binsize < 1 || $Binsize > $SecPerDay) {
            die("Invalid bin size (-b option) $Binsize");
        }
    }
    if (defined $opt_d) {
        $Datadir =  $opt_d;
    }
    if ($opt_l) {
        $BinBy |= 1;
    }
    if (defined $opt_o) {
        $OutputFile = $opt_o;
    }
    if ($opt_s) {
        $BinBy |= 2;
    }

    opendir(DF, $Datadir) || die("Cannot open data directory $Datadir: $!");
#print("BinBy = $BinBy\n"); exit(0);

    #   Iterate over files in egg data directory

main:
    while ($f = readdir(DF)) {
        if ($f =~ m/\.csv\.gz$/) {
print("Processing: $f\n");
            open(IF, "zcat $Datadir/$f |") || die("Cannot open data file $Datadir/$f: $!");

            #   Process records in this file

            $lbin = -1;
            while ($l = <IF>) {
                @fields = &csv($l);
                if ($fields[0] == 10 && $fields[1] == 4) {

                    #   Save trial size for records in thie file

                    $trialsize = $fields[2];
#print("Trial size = $trialsize\n");
                } elsif ($fields[0] == 12) {

                    #   Build mapping of field number to egg number

                    for ($i = 3; $i <= $#fields; $i++) {
                        $eggs[$i] = $fields[$i];
#print("Egg $i: $eggs[$i]\n");
                    }
                } elsif ($fields[0] == 13) {

                    #   Process egg samples in this record,
                    #   adding data for eggs reporting to the
                    #   binned time of the record, adjusted to
                    #   the local time at the egg.

                    for ($i = 3; $i <= $#fields; $i++) {
                        if ((defined $fields[$i]) &&
                            ($fields[$i] ne '')) {
#if (!(defined $offset[$eggs[$i]])) {
#  print("BARF!!!  Egg[$i] = $eggs[$i] offset not defined!\n");
#}
                            $etime = &TransformTime($fields[1], $eggs[$i]);
                            $bin = int(($etime % $SecPerDay) / $Binsize);
                            $Trials[$bin] += $trialsize;
                            $Ones[$bin] += $fields[$i];
#if ($lbin != $bin) {
#    if ($lbin != -1) {
#        printf("Bin $bin: $Ones[$bin]/$Trials[$bin] %9.4f\n", ($Ones[$bin] * $trialsize) / $Trials[$bin]);
#    }
#    $lbin = $bin;
#}
                        }
                    }
                }
            }
#
#           #   Dump results for this pass to summary file
#
#           open(OF, ">$OutputFile") || die("Cannot open output file: $!");
#           for ($i = 0; $i < int($SecPerDay / $Binsize); $i++) {
#               printf(OF "%d,%d,%d,%.5f\n", $i * $Binsize,
#                   $Ones[$i], $Trials[$i], ($Ones[$i] * $trialsize) / $Trials[$i]);
#           }
#           close(OF);

# last main;
        }
    }
    closedir(DF);

    #   Write final results

    open(OF, ">$OutputFile") || die("Cannot open output file: $!");
    for ($i = 0; $i < int($SecPerDay / $Binsize); $i++) {
        printf(OF "%d,%d,%d,%.5f\n", $i * $Binsize,
            $Ones[$i], $Trials[$i], ($Ones[$i] * $trialsize) / $Trials[$i]);
    }
    close(OF);

    #   Prepare summary plot of data

    @plotTitle = ( 'Universal time', 'Local mean solar time',
                   'Greenwich mean sidereal time', 'Local mean sidereal time' );

    $ogif = $OutputFile;
    $ogif =~ s/\.\w+/\.gif/;
    system("perl lwplot.pl -i $OutputFile -o $ogif -t \"$plotTitle[$BinBy]\"");

    #   Subroutine to transform UTC to requested binning time

    sub TransformTime {
        local($ot, $egg) = @_;
        local($julianDate, $gmSt, $t);

        if ($BinBy < 0 || $BinBy >= 4) {
            die "TransformTime: Invalid BinBy value: $BinBy";
        }

        #   Quick bail-out for UTC, the null transform

        if ($BinBy == 0) {            # 0: UTC
             return $ot;
        }

        #   First of all, see if we're working with solar
        #   or sidereal time.  If sidereal time, transform
        #   UTC to GMST.

        $t = $ot;
        if ($BinBy == 2 || $BinBy == 3) {
            local($mon, $mday, $hour, $min, $sec);

            ($sec, $min, $hour, $mday, $mon, $year) = gmtime($t);
            $julianDate = &utctoj($year + 1900, $mon, $mday, $hour, $min, $sec);
            $gmSt = &gmst($julianDate);
            $t = int($gmSt * 60 * 60);
#printf("  JD = $julianDate GMST = $gmSt stime = %d\n", $stime);
        }

        #   If the transform type is odd, we want the
        #   corresponding local time at the egg's location.
        #   We compute this by applying the offset between
        #   the egg's local time and the Greenwich meridian.

        if ($BinBy & 1) {
            $t = $t + $offset[$egg];
        }

        #   If transformed time is in an adjacent day, adjust it
        #   to be time within that day.

        if ($t < 0) {
            $t += $SecPerDay;
        } elsif ($t >= $SecPerDay) {
            $t -= $SecPerDay;
        }

#{
#    local($ss, $mm, $hh, $tss, $tmm, $thh);
#
#($ss, $mm, $hh) = gmtime($stime);
#printf(STDERR "Sample time Egg %4d   %02d:%02d:%02d\n", $egg, $hh, $mm, $ss);
#    ($ss, $mm, $hh) = gmtime($ot);
#    ($tss, $tmm, $thh) = gmtime($t);
#    printf(STDERR "Txform $Binby Egg %4d   %02d:%02d:%02d ==> %02d:%02d:%02d\n",
#        $egg, $hh, $mm, $ss, $thh, $tmm, $tss);
#}
        return $t;
    }

    #   UTCTOJ  --  Convert GMT date and time to astronomical
    #               Julian time (i.e. Julian date plus day fraction,
    #               expressed as a double).
    #
    #               IMPORTANT:  The month argument ($mon) is a number
    #               between 0 (January) and 11 (December), *not* a
    #               1-based index as usually written in dates.  This
    #               is compatible with the month index returned by
    #               gmtime().

    sub utctoj {
        local($year, $mon, $mday, $hour, $min, $sec) = @_;
        local($a, $b, $m, $y);

        #  Algorithm as given in Meeus, Astronomical Algorithms, Chapter 7, page 61

        die "utctoj: argument out of range" unless ($mon  >= 0 && $mon  < 12);
        die "utctoj: argument out of range" unless ($mday >  0 && $mday < 32);
        die "utctoj: argument out of range" unless ($hour >= 0 && $hour < 24);
        die "utctoj: argument out of range" unless ($min  >= 0 && $min  < 60);
        die "utctoj: argument out of range" unless ($sec  >= 0 && $sec  < 60);

        $m = $mon + 1;
        $y = $year;

        if ($m <= 2) {
            $y--;
            $m += 12;
        }

        #  Determine whether date is in Julian or Gregorian calendar based on
        #  canonical date of calendar reform.

        if (($year < 1582) || (($year == 1582) &&
            (($mon < 9) || ($mon == 9 && $mday < 5)))) {
            $b = 0;
        } else {
            $a = int($y / 100);
            $b = 2 - $a + int($a / 4);
        }

        ((int(365.25 * ($y + 4716))) + (int(30.6001 * ($m + 1))) +
                    $mday + $b - 1524.5) +
                (($sec + 60 * ($min + 60 * $hour)) / 86400.0);
    }

    #  GMST  --  Calculate Greenwich Mean Sidereal Time for a given
    #            instant expressed as a Julian date and fraction.

    sub gmst {
        local ($jd) = @_;
        local ($t, $theta0);

        #  Time, in Julian centuries of 36525 ephemeris days,
        #  measured from the epoch 1900 January 0.5 ET.

        $t = ((int($jd + 0.5) - 0.5) - 2415020.0) / 36525.0;

        $theta0 = 6.6460656 + 2400.051262 * $t + 0.00002581 * $t * $t;

        $t = ($jd + 0.5) - (int($jd + 0.5));

        $theta0 += ($t * 24.0) * 1.002737908;

        ($theta0 - 24.0 * (int($theta0 / 24.0)));
    }
